/**
 * 全局常量
 */
var DEBUG=false;

var CHANNEL_BAR_SHOW_TIME = 5000;
var MEDIA_BAR_SHOW_TIME = 8000;
var LOGICNUM_SHOW_TIME = 3000;
 
var mediaFlag=0;
var GLOBAL_KEY_CODE=80700;//apk发送事件消息

var MAINMENU_LIVE = 0;
var MAINMENU_VOD = 1;
var MAINMENU_AUDIO = 2;
var MAINMENU_GUIDE = 3;
var MAINMENU_SETTING = 4;
var MAINMENU_MAX = 4;

/**
 * 接收ａｐｋ的消息常量集
 */
var tools = {
	/**
	 * [接收应用发过来的消息]
	 * @param  {[int]} code [发过来的消息类型]
	 * @return {[type]}      [description]
	 */
	"apkMessage":function(code,agr){
		switch(code){
			case GLOBAL_KEY_CODE:{
                var e=$.Event("keydown");
                e.keyCode=agr;
                $(document).trigger(e);
                break;
			}
		}
	},
	
	"onUrlStarted":function(link_url,link_type){
		if(!DEBUG)
		window.nova.onUrlStarted(link_url,link_type);
	},
	
	"onMediaStart":function(){
		if(!DEBUG)
		window.nova.onMediaStart();
	},
	
	"onMediaStop":function(){
		if(!DEBUG)
		window.nova.onMediaStop();
	},
	
	"onMediaPause":function(){
		if(!DEBUG)
		window.nova.onMediaPause();
	},
	
	"startApp":function(packageName,activityName){
		if(!DEBUG)
		window.nova.startIntent(packageName,activityName);
	},
	
	"setVideoScale":function(){
		if(!DEBUG) {
			if(window.nova.getDeviceType()=="p201") {
				window.nova.setVideoScale(560,320,-625,308);//(width,height,x_offset,y_offset)
			} else {
				window.nova.setVideoScale(370,260,-415,208);
			}
		}
	},
	
	"setFullScreen":function(){
		if(!DEBUG)
		window.nova.setVideoScale(0,0,0,0);
	},
	
	"quit":function(){
		//if(!DEBUG)
		window.nova.quit();
		//window.location.href="main.php";
	},
	
	/**
		* dateFormat(date,formatter)
		* 日期对象格式化
		* y或Y：表示年份，当y为两位时，输出年份后两位，为四位时，输出完整的年份
		* M：表示月份
		* d：表示日期
		* h：表示小时
		* m：表示分钟
		* s：表示秒钟
		* w：表示星期
		* @param {Object} date 要进行格式化的Date对象
		* @param {String} formatter 格式字符串，形如“yyyy-MM-dd hh:mm:ss w”
		* @param {boolean} isEng是否是英文 
		* @return {String} dateStr 格式化后的日期字符串
	*/
	"dateFormat":function(d, formatter,isEng,is24h){
		if (!formatter || formatter == "") {
			formatter = "yyyy-MM-dd";
		}
		
		var weekdays = [["周一","周二","周三","周四","周五","周六","周日"], ["Sun.", "Mon.", "Tue.", "Wed.", "Thu.", "Fri.", "Sat."]];
		var month_us=["Jan.","Feb.","Mar.","Apr.","May","Jun.","Jul.","Aug.","Sep.","Oct.","Nov.","Dec."];
		var year = (d.getFullYear()).toString();
		var month = (d.getMonth() + 1).toString();
		var date = d.getDate().toString();
		var day = d.getDay();
		var hour = d.getHours().toString();
		var minute = d.getMinutes().toString();
		var second = d.getSeconds().toString();
		
		if(!is24h) {
			if(d.getHours()>=12)
				hour=(d.getHours()-12).toString();
		}
		
		var yearMarker = formatter.replace(/[^y|Y]/g, '');
		if (yearMarker.length == 2) {
			year = year.substring(2, 4);
		} else if (yearMarker.length == 0) {
			year = "";
		}
		
		var monthMarker = formatter.replace(/[^M]/g, '');
		if (monthMarker.length > 1) {
			if (month.length == 1) {
				month = "0" + month;
			}
		} else if (monthMarker.length == 0) {
			month = "";
		}
		
		var dateMarker = formatter.replace(/[^d]/g, '');
		if (dateMarker.length > 1) {
			if (date.length == 1) {
				date = "0" + date;
			}
		} else if (dateMarker.length == 0) {
			date = "";
		}
		
		var hourMarker = formatter.replace(/[^h]/g, '');
		if (hourMarker.length > 1) {
			if (hour.length == 1) {
				hour = "0" + hour;
			}
		} else if (hourMarker.length == 0) {
			hour = "";
		}
		
		var minuteMarker = formatter.replace(/[^m]/g, '');
		if (minuteMarker.length > 1) {
			if (minute.length == 1) {
				minute = "0" + minute;
			}
		} else if (minuteMarker.length == 0) {
			minute = "";
		}
		
		if(!is24h) {
			if(d.getHours()>=12)
				minute=minute+"PM";
			else
				minute=minute+"AM";
		}
		
		var secondMarker = formatter.replace(/[^s]/g, '');
		if (secondMarker.length > 1) {
			if (second.length == 1) {
				second = "0" + second;
			}
		} else if (secondMarker.length == 0) {
			second = "";
		}
		
		var dayMarker = formatter.replace(/[^w]/g, '');
		var weekDay = "";
		if(isEng){
			if (dayMarker.length > 0) weekDay = weekdays[1][day];
		}else{
			if (dayMarker.length > 0) weekDay = weekdays[0][day];
		}

		if(isEng){
			if(month==""){
				var dateStr = formatter.replace(yearMarker, year).replace(dateMarker, date).replace(hourMarker, hour).replace(minuteMarker, minute).replace(secondMarker, second).replace(dayMarker, weekDay);
			}else{
				var dateStr = formatter.replace(yearMarker, year).replace(monthMarker, month_us[parseInt(month-1)]).replace(dateMarker, date).replace(hourMarker, hour).replace(minuteMarker, minute).replace(secondMarker, second).replace(dayMarker, weekDay);
			}
		}else{
			var dateStr = formatter.replace(yearMarker, year).replace(monthMarker, month-1).replace(dateMarker, date).replace(hourMarker, hour).replace(minuteMarker, minute).replace(secondMarker, second).replace(dayMarker, weekDay);
		}
		return dateStr;
	},
	/**
	 * 将秒转化成分钟,例如120->2:00
	 * @param  {[int]} second_ [需要转化的秒数]
	 * @return {[String]} [已分钟字符串的形式返回]
	 */
	"secondToMinute":function(second_){
		var fianlyTime ="";
		var minute = second_/60;
		minute =parseInt(minute);
		if(minute<10){
			fianlyTime += "0"+minute;
		}else{
			fianlyTime +=minute;
		}
		fianlyTime +=":";
		var second = second_%60;
		if(parseInt(second)<10){
			fianlyTime +="0"+second;
		}else{
			fianlyTime +=second;
		}
		return  fianlyTime;
	},

	"getCookie":function(c_name){
	  if (document.cookie.length>0){
	  	var c_start=document.cookie.indexOf(c_name + "=");
	  	if (c_start!=-1){
	    	c_start=c_start + c_name.length + 1;
	    	var c_end=document.cookie.indexOf(";",c_start);
	    	if (c_end==-1) c_end=document.cookie.length;
	    	return unescape(document.cookie.substring(c_start,c_end));
	    }
	  }
		return "";
	},

	"setCookie":function(c_name,value){
		document.cookie=c_name+ "=" +escape(value);
	},
}




