<?php
header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");// 과거의 날짜
header("Last-Modified: " . gmdate("D, d M Y H:i ") . " GMT");// 항상 변경됨
header("Cache-Control: no-store, no-cache, must-revalidate");// HTTP/1.1
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");   // HTTP/1.0



$noscript = "<noscript>자바스크립트를 지원하지 않는 브라우저입니다.</noscript>\n";

// 메시지 띠우기
function message($str) { echo "<script language=javascript>alert('$str');history.go(-1);</script>"; exit; }
function alert($str) { echo "<script language=javascript>alert('$str');</script>"; }
function alert2($str, $url='') { echo "<script language=javascript>alert('$str');</script>"; if ($url) { redirect($url); } }

// 리다이렉트
function redirect($url) { echo "<script language=javascript>location.replace('$url');</script>"; exit; }
function redirect_top($url) { echo "<script language=javascript>top.location.replace('$url');</script>"; exit; }
function redirect_opener($str) { echo "<script language=javascript>opener.location.href='$str';</script>"; }
function redirect_parent($str) { echo "<script language=javascript>parent.location.href='$str';</script>"; exit; }

// 창닫기
function close_win() { echo '<script language=javascript>window.close();</script>'; exit; }
// 부모창 리로드
function refresh_opener() { echo '<script language=javascript>opener.location.reload();</script>'; }

// 파라미터 디버깅
function pdstr() {

	global $_GET;
	global $_POST;
	global $_SESSION;
	global $_SERVER;

	echo "<textarea style='width:700;height:500'>";

	echo "\n\nprint_r(\$_GET)\n";
	echo "----------------------------------------------------------------\n\n";
	print_r($_GET);

	echo "\n\nprint_r(\$_POST)\n";
	echo "----------------------------------------------------------------\n\n";
	print_r($_POST);

	echo "\n\nprint_r(\$_SESSION)\n";
	echo "----------------------------------------------------------------\n\n";
	print_r($_SESSION);

	echo "\n\nprint_r(\$_SERVER)\n";
	echo "----------------------------------------------------------------\n\n";
	print_r($_SERVER);

	echo "</textarea>";

	exit;
}


function nopermit() {
	echo "<p align='center' style='color:#CC0000;font-weight:bold'>권한이 부족하여 접근하실 수 없습니다! 관리자에게 문의 바랍니다.</p>";
	exit;
}

// 특정 스트링을 아이콘 태그로 리턴
function get_icon($icon, $dir='./icons')
{
    $str = "";

    if ($icon == '->')
    {
        $str = "<img src='$dir/arrow.gif' style='filter:gray()' border='0'>";
    }
    else if ($icon == '*>')
    {
        $str = "<img src='$dir/arrow.gif' border='0'>";
    }
    else if ($icon == '|')
    {
        $str = "<img src='$dir/sep.gif' border='0' align='absmiddle'>";
    }

    return $str;

}

/**
 * HTML 에디터를 얻음
 *
 * @param $name     인스턴스 이름
 * @param $content  내용(수정시 입력되는 텍스트 내용)
 * @param $width    에디터의 너비
 * @param $height   에디터의 높이
 * @param $order    에디터 순번
 */
function get_editor($name, $content, $width, $height, $order="1")
{
    $str = "";
    $str .= " <iframe id='FCKeditor$order___Frame' src='/fckeditor/editor/fckeditor.html?InstanceName=FCKeditor$order&amp;Toolbar=Default' width='$width' height='$height' frameborder='0' scrolling='no'></iframe>";
    $str .= " <input type='hidden' id='FCKeditor$order___Config' value='AutoDetectLanguage=true&amp;DefaultLanguage=en' style='display:none' />";
    $str .= " <textarea id='FCKeditor$order' name='$name' style='display:none'>$content</textarea>";

    return $str;
}

/**
 * 네비게이션 버튼 링크 처리
 *
 * @param $cmd      명령
 * @param $iconDir  아이콘 디렉토리
 * @param $anchor   링크
 * @param $bprint   바로출력인가?
 *
 */
function navi($cmd, $anchor='', $attr='', $bprint=false, $iconDir='../icons')
{
    $str = "&nbsp;";

    switch($cmd)
    {
    case 'submit':
		$str = "<input type='image' src='$iconDir/submit.gif' border='0' align='absmiddle' ".$attr." >";
		break;
    case 'search':
		$str = "<input type='image' src='$iconDir/search.gif' border='0' align='absmiddle' ".$attr." >";
		break;
    case 'cancel':
		if (!$anchor)
			$str .= "<a href='javascript:history.back();'>";
		else
			$str .= "<a href='".$anchor."' ".$attr." >";
		$str .= "<img src='$iconDir/cancel.gif' border='0' align='absmiddle'></a>";
		break;
    case 'list':
		$str .= "<a href='".$anchor."'><img src='$iconDir/list.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
    case 'delete':
		$str .= "<a href='".$anchor."'><img src='$iconDir/delete.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
    case 'edit':
		$str .= "<a href='".$anchor."'><img src='$iconDir/edit.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
    case 'post':
		$str .= "<a href='".$anchor."'><img src='$iconDir/post.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
    case 'reply':
		$str .= "<a href='".$anchor."'><img src='$iconDir/reply.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
    case 'add_comment':
		$str = "<input type='image' src='$iconDir/addcomment.gif' border='0' align='absmiddle' ".$attr." >";
		break;
    case 'delete_comment':
		$str .= "<a href='".$anchor."'><img src='$iconDir/com_delete.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
    case 'sdelete':
		$str .= "<a href='".$anchor."'><img src='$iconDir/delete_s.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
    case 'sedit':
		$str .= "<a href='".$anchor."'><img src='$iconDir/edit_s.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
    case 'spost':
		$str .= "<a href='".$anchor."'><img src='$iconDir/post_s.gif' border='0' align='absmiddle' ".$attr." ></a>";
		break;
	}

	$str .= "\n";

    if ($bprint) echo $str;

    return $str;
}

/**
 * 답변 아이콘
 *
 * @param $depth  게시글 깊이
 * @param $icon_dir 아이콘 디렉토리
 */
function get_re($depth, $icon_dir='./icons')
{
    $str = "";

    if ($depth > 0)
	{
		for ($i = 0; $i < $depth; $i++ ) $str .= "&nbsp;&nbsp;&nbsp;&nbsp;";
        $str .= "<img src='".$icon_dir."/re.gif' border='0' align='middle'>";
	}

    return $str;
}

/**
 * 새로운 게시글 아이콘
 *
 * @param $wdate  작성 날짜
 * @param $period 아이콘 표시 기간
 * @param $icon_dir 아이콘 디렉토리
 */
function get_new_icon($wdate, $period, $icon_dir='./icons')
{
    global $board_icon_dir;

    $str = "";

    $today = date("Y-m-d");

    if ( datediff($today, $wdate) < $period)
        $str = "<img src='".$icon_dir."/new.gif' border='0' align='absmiddle'>";

    return $str;
}


/**
 * 페이징 처리
 *
 * @param $pz_info 페이징 처리에 대한 배열
 *  $pz_info[PAGE_NAME]  = $PHP_SELF;
 *  $pz_info[PAGE]       = $page;
 *  $pz_info[PAGE_NUM]   = $page_num;
 *  $pz_info[PAGE_BLOCK] = $page_block;
 *  $pz_info[TOTAL_NUM]  = $total_num;
 *  $pz_info[PARAMS]     = $etc;
 *  $pz_info[USE_ICON]   = true;
 *  $pz_info[ICON_DIR]   = "./icons";
 */
/*
function set_page($pz_info)
{
	$src = "<table width='100%' cellspacing='0' cellpadding='0' border='0'><tr><td align='center' height='40'>{PageList}</td></tr></table>";
	$str = "";

	// 블럭 = 페이지 단위
	// 페이지 블럭 : 페이지에 출력될 페이지 번호 목록 갯수

	$pz_page_total    = ceil($pz_info[TOTAL_NUM] / $pz_info[PAGE_NUM]);		// 페이지 갯수
	$pz_block_total   = ceil($pz_page_total / $pz_info[PAGE_BLOCK]);		// 페이지 블럭 갯수
	$pz_block_current = ceil($pz_info[PAGE] / $pz_info[PAGE_BLOCK]);		// 현재 페이지 블럭 번호
	$pz_block_first   = ($pz_block_current - 1) * $pz_info[PAGE_BLOCK] + 1; // 페이지 블럭의 첫번째 블럭 번호
	$pz_block_last    = ($pz_block_first - 1)  + $pz_info[PAGE_BLOCK];		// 페이지 블럭의 마지막 블럭 번호

	if ($pz_block_last > $pz_page_total) // 끝 블럭이 마지막 페이지보다 크면
		$pz_block_last = $pz_page_total;

	// 이전 10개
	if ($pz_block_current > 1) // 현재 페이지 블럭 번호가 1보다 크면, 즉 페이지 번호가 11이상이면
	{
		$pz_page_prev = $pz_block_first - 1; // 이전 페이지 블럭에 마지막 페이지 번호

        $str.= '<a href='.$pz_info[PAGE_NAME].'?page='.$pz_page_prev.$pz_info[PARAMS].'>';

        if ($pz_info[USE_ICON])
            $str.= ' <img src="'.$pz_info[ICON_DIR].'/prev10.gif" border="0" align="absmiddle">';
        else
            $str.= '[이전'.$pz_info[PAGE_BLOCK].'개]';

        $str.= '</a>';
	}
	else
	{
        if (!$pz_info[USE_ICON])
            $str .= '[이전'.$pz_info[PAGE_BLOCK].'개]';
	}

	// 이전 글
//	if ($pz_info[PAGE] - 1 > 0)
//	{
//		$str.= ' <a href='.$pz_info[PAGE_NAME].'?page='.($pz_info[PAGE] - 1).$pz_info[PARAMS].'>';
//		$str.= '<img src="'.$pz_info[ICON_DIR].'/prev.gif" border="0" align="absmiddle">';
//        $str.= '</a>';
//	}


	// 페이지 블럭만큼
	for ($i = $pz_block_first; $i <= $pz_block_last; $i++)
	{
		if ($i == $pz_info[PAGE])
		{
			$str .= '&nbsp; <font color="#df852d" style="font-size:10pt;"><b>'.$i.'</b></font>';
		}
		else
		{
			$str .= '&nbsp; <a href='.$pz_info[PAGE_NAME].'?page='.$i.$pz_info[PARAMS].'><font style="font-size:9pt;">'.$i.'</font></a>';
		}
	}

	// 다음 글
//	if ($pz_info[PAGE]+1 <= $pz_page_total)
//	{
//		$str.= '&nbsp;&nbsp;<a href='.$pz_info[PAGE_NAME].'?page='.($pz_info[PAGE] + 1).$pz_info[PARAMS].'>';
//		$str.= '<img src="'.$pz_info[ICON_DIR].'/next.gif" border="0" align="absmiddle">';
//        $str.= '</a>';
//	}

	// 다음 10개
	if ($pz_block_current < $pz_block_total)
	{
		$pz_page_next = $pz_block_last + 1; // 다음 블럭의 첫번째 페이지 번호

        $str.= ' <a href='.$pz_info[PAGE_NAME].'?page='.$pz_page_next.$pz_info[PARAMS].'>';

        if ($pz_info[USE_ICON])
            $str.= '<img src="'.$pz_info[ICON_DIR].'/next10.gif" border="0" align="absmiddle">';
        else
            $str.= '[다음'.$pz_info[PAGE_BLOCK].'개]';

        $str.= '</a>';

	}
	else
	{
        if (!$pz_info[USE_ICON])
            $str .= ' [다음'.$pz_info[PAGE_BLOCK].'개]';
	}

	$src = str_replace("{PageList}", $str, $src);

	return $src;
}
*/


function set_page($pz_info)
{
	$src = "<table width='100%' cellspacing='0' cellpadding='0' border='0'><tr><td align='center' height='40'>{PageList}</td></tr></table>";
	$str = "";

	// 블럭 = 페이지 단위
	// 페이지 블럭 : 페이지에 출력될 페이지 번호 목록 갯수

	$pz_page_total    = ceil($pz_info[TOTAL_NUM] / $pz_info[PAGE_NUM]);		// 페이지 갯수
	$pz_block_total   = ceil($pz_page_total / $pz_info[PAGE_BLOCK]);		// 페이지 블럭 갯수
	$pz_block_current = ceil($pz_info[PAGE] / $pz_info[PAGE_BLOCK]);		// 현재 페이지 블럭 번호
	$pz_block_first   = ($pz_block_current - 1) * $pz_info[PAGE_BLOCK] + 1; // 페이지 블럭의 첫번째 블럭 번호
	$pz_block_last    = ($pz_block_first - 1)  + $pz_info[PAGE_BLOCK];		// 페이지 블럭의 마지막 블럭 번호

	if ($pz_block_last > $pz_page_total) // 끝 블럭이 마지막 페이지보다 크면
		$pz_block_last = $pz_page_total;

	// 이전 10개
	if ($pz_block_current > 1) // 현재 페이지 블럭 번호가 1보다 크면, 즉 페이지 번호가 11이상이면
	{
		$pz_page_prev = $pz_block_first - 1; // 이전 페이지 블럭에 마지막 페이지 번호

        $str.= '<a href='.$pz_info[PAGE_NAME].'?page='.$pz_page_prev.$pz_info[PARAMS].'>';

        if ($pz_info[USE_ICON])
            $str.= ' <img src="'.$pz_info[ICON_PREV10].'" border="0" align="absmiddle">';
        else
            $str.= '[이전'.$pz_info[PAGE_BLOCK].'개]';

        $str.= '</a>';
	}
	else
	{
        if (!$pz_info[USE_ICON])
		{
            $str .= '[이전'.$pz_info[PAGE_BLOCK].'개]';
		}
	}

	// 이전 글
	if ($pz_info[PAGE] - 1 > 0)
	{
		$str.= ' <a href='.$pz_info[PAGE_NAME].'?page='.($pz_info[PAGE] - 1).$pz_info[PARAMS].'>';
        if ($pz_info[USE_ICON])
			$str.= '<img src="'.$pz_info[ICON_PREV].'" border="0" align="absmiddle">';
		else
			$str .= '[이전]';
        $str.= '</a>';
	} else {
		$str.= '<img src="'.$pz_info[ICON_PREV].'" border="0" align="absmiddle">';
	}


	// 페이지 블럭만큼
	for ($i = $pz_block_first; $i <= $pz_block_last; $i++)
	{
		if ($i == $pz_info[PAGE])
		{
			$str .= '&nbsp; <font color="#df852d" style="font-size:10pt;"><b>'.$i.'</b></font>';
		}
		else
		{
			$str .= '&nbsp; <a href='.$pz_info[PAGE_NAME].'?page='.$i.$pz_info[PARAMS].'><font style="font-size:9pt;">'.$i.'</font></a>';
		}
	}

	// 다음 글
	if ($pz_info[PAGE]+1 <= $pz_page_total)
	{
		$str.= '&nbsp;&nbsp;<a href='.$pz_info[PAGE_NAME].'?page='.($pz_info[PAGE] + 1).$pz_info[PARAMS].'>';
        if ($pz_info[USE_ICON])
			$str.= '<img src="'.$pz_info[ICON_NEXT].'" border="0" align="absmiddle">';
		else
			$str.= '[다음]';
        $str.= '</a>';
	} else {
		$str.= '&nbsp;&nbsp;<img src="'.$pz_info[ICON_NEXT].'" border="0" align="absmiddle">';
	}


	// 다음 10개
	if ($pz_block_current < $pz_block_total)
	{
		$pz_page_next = $pz_block_last + 1; // 다음 블럭의 첫번째 페이지 번호

        $str.= ' <a href='.$pz_info[PAGE_NAME].'?page='.$pz_page_next.$pz_info[PARAMS].'>';

        if ($pz_info[USE_ICON])
            $str.= '<img src="'.$pz_info[ICON_NEXT10].'" border="0" align="absmiddle">';
        else
            $str.= '[다음'.$pz_info[PAGE_BLOCK].'개]';

        $str.= '</a>';

	}
	else
	{
        if (!$pz_info[USE_ICON])
            $str .= ' [다음'.$pz_info[PAGE_BLOCK].'개]';
	}

	$src = str_replace("{PageList}", $str, $src);

	return $src;
}


/*
<a href=""><img src="../images/first.gif" alt="맨처음으로" /></a>
<a href=""><img src="../images/prev02.gif" alt='앞으로' style="margin-right:10px;"></a>
<span class='title'>1</span>
<img src="../images/paging_bar.gif" width="9" height="7" border="0" alt="">
<a href="">2</a>
<img src="../images/paging_bar.gif" width="9" height="7" border="0" alt="">
<a href="">3</a>
<img src="../images/paging_bar.gif" width="9" height="7" border="0" alt="">
<a href="">4</a>
<img src="../images/paging_bar.gif" width="9" height="7" border="0" alt="">
<a href="">5</a>
<a href=""><img src="../images/next02.gif" alt="다음으로" style="margin-left:10px" /></a>
<a href=""><img src="../images/last.gif" alt="맨끝으로" border="0" /></a>
*/


function set_page_search($pz_info)
{
	//$src = "<table width='100%' cellspacing='0' cellpadding='0' border='0'><tr><td align='center' height='40'>{PageList}</td></tr></table>";

//		echo "//".$pz_info[ICON_FIRST]."//";

	$str = "";

	// 블럭 = 페이지 단위
	// 페이지 블럭 : 페이지에 출력될 페이지 번호 목록 갯수

	$pz_page_total    = ceil($pz_info[TOTAL_NUM] / $pz_info[PAGE_NUM]);		// 페이지 갯수
	$pz_block_total   = ceil($pz_page_total / $pz_info[PAGE_BLOCK]);		// 페이지 블럭 갯수
	$pz_block_current = ceil($pz_info[PAGE] / $pz_info[PAGE_BLOCK]);		// 현재 페이지 블럭 번호
	$pz_block_first   = ($pz_block_current - 1) * $pz_info[PAGE_BLOCK] + 1; // 페이지 블럭의 첫번째 블럭 번호
	$pz_block_last    = ($pz_block_first - 1)  + $pz_info[PAGE_BLOCK];		// 페이지 블럭의 마지막 블럭 번호

	if ($pz_block_last > $pz_page_total) // 끝 블럭이 마지막 페이지보다 크면
		$pz_block_last = $pz_page_total;


	// 처음
	if ($pz_block_current > 0)
	{
		$str.= '<a href='.$pz_info[PAGE_NAME].'?page=1'.$pz_info[PARAMS].'>';

		if ($pz_info[USE_ICON])
			$str.= ' <img src="'.$pz_info[ICON_FIRST].'" border="0" align="absmiddle" alt="첫 페이지로 이동">';
		else
			$str.= '[처음]';

		$str.= '</a>';
	}
	else
	{
		if ($pz_info[USE_ICON])
			$str.= ' <img src="'.$pz_info[ICON_FIRST].'" border="0" align="absmiddle" alt="첫 페이지로 이동">';
		else
			$str.= '[처음]';

	}

	// 이전 10개
	if ($pz_block_current > 1) // 현재 페이지 블럭 번호가 1보다 크면, 즉 페이지 번호가 11이상이면
	{
		$pz_page_prev = $pz_block_first - 1; // 이전 페이지 블럭에 마지막 페이지 번호

        $str.= '<a href='.$pz_info[PAGE_NAME].'?page='.$pz_page_prev.$pz_info[PARAMS].'>';

        if ($pz_info[USE_ICON])
            $str.= ' <img src="'.$pz_info[ICON_PREV10].'" border="0" align="absmiddle" alt="이전 10 페이지로 이동" style="margin-right:5px;">';
        else
            $str.= '[이전'.$pz_info[PAGE_BLOCK].'개]';

        $str.= '</a>';
	}
	else
	{
        if ($pz_info[USE_ICON])
		{
            $str.= ' <img src="'.$pz_info[ICON_PREV10].'" border="0" align="absmiddle" alt="이전 10 페이지로 이동" style="margin-right:5px;">';
		} else {
            $str .= '[이전'.$pz_info[PAGE_BLOCK].'개]';
		}
	}

	// 이전 글
//	if ($pz_info[PAGE] - 1 > 0)
//	{
//		$str.= ' <a href='.$pz_info[PAGE_NAME].'?page='.($pz_info[PAGE] - 1).$pz_info[PARAMS].'>';
//        if ($pz_info[USE_ICON])
//			$str.= '<img src="'.$pz_info[ICON_PREV10].'" border="0" align="absmiddle alt="이전 페이지로 이동">';
//		else
//			$str .= '[이전]';
//        $str.= '</a>';
//	} else {
//		$str.= '<img src="'.$pz_info[ICON_PREV10].'" border="0" align="absmiddle alt="이전 페이지로 이동">';
//	}

	// 페이지 블럭 출력
	for ($i = $pz_block_first; $i <= $pz_block_last; $i++)
	{
		if ($i == $pz_info[PAGE])
		{
			//$str .= '&nbsp; <font color="#df852d" style="font-size:10pt;"><b>'.$i.'</b></font>';
			$str .= ' <span class="title">'.$i.'</span> ';
		}
		else
		{
			$str .= ' <a href='.$pz_info[PAGE_NAME].'?page='.$i.$pz_info[PARAMS].'>'.$i.'</a> ';
		}

		if ($i != $pz_block_last)
		{
			$str .= '<img src="'.$pz_info[ICON_BAR].'" border="0" alt=""> ';
		}

	}

	// 다음 글
//	if ($pz_info[PAGE]+1 <= $pz_page_total)
//	{
//		$str.= '&nbsp;&nbsp;<a href='.$pz_info[PAGE_NAME].'?page='.($pz_info[PAGE] + 1).$pz_info[PARAMS].'>';
//        if ($pz_info[USE_ICON])
//			$str.= '<img src="'.$pz_info[ICON_NEXT10].'" border="0" align="absmiddle" alt="다음 페이지로 이동">';
//		else
//			$str.= '[다음]';
//        $str.= '</a>';
//	} else {
//		$str.= '&nbsp;&nbsp;<img src="'.$pz_info[ICON_NEXT10].'" border="0" align="absmiddle" alt="다음 페이지로 이동">';
//	}


	// 다음 10개
	if ($pz_block_current < $pz_block_total)
	{
		$pz_page_next = $pz_block_last + 1; // 다음 블럭의 첫번째 페이지 번호

        $str.= ' <a href='.$pz_info[PAGE_NAME].'?page='.$pz_page_next.$pz_info[PARAMS].'>';

        if ($pz_info[USE_ICON])
            $str.= '<img src="'.$pz_info[ICON_NEXT10].'" border="0" align="absmiddle" alt="다음 10 페이지로 이동" style="margin-left:5px">';
        else
            $str.= '[다음'.$pz_info[PAGE_BLOCK].'개]';

        $str.= '</a>';

	}
	else
	{
        if ($pz_info[USE_ICON])
            $str.= '<img src="'.$pz_info[ICON_NEXT10].'" border="0" align="absmiddle" alt="다음 10 페이지로 이동" style="margin-left:5px">';
		else
            $str .= ' [다음'.$pz_info[PAGE_BLOCK].'개]';
	}

	// 마지막페이지
	if ($pz_block_current < $pz_block_total)
	{
        $str.= ' <a href='.$pz_info[PAGE_NAME].'?page='.$pz_page_total.$pz_info[PARAMS].'>';

        if ($pz_info[USE_ICON])
            $str.= '<img src="'.$pz_info[ICON_LAST].'" border="0" align="absmiddle" align="absmiddle" alt="마지막 페이지로 이동">';
        else
            $str.= '[끝]';

        $str.= '</a>';

	}
	else
	{
        if ($pz_info[USE_ICON])
            $str.= '<img src="'.$pz_info[ICON_LAST].'" border="0" align="absmiddle" align="absmiddle" alt="마지막 페이지로 이동">';
		else
            $str .= ' [끝]';
	}



	$src = $str;//str_replace("{PageList}", $str, $src);

	return $src;
}




/**
 * 두 날짜의 일수 차
 *
 * @param $date1 시작날짜
 * @param $date2 끝날짜
 */
function datediff($date1, $date2)
{
    $_date1 = explode("-", $date1);
    $_date2 = explode("-", $date2);
    $tm1 = mktime(0, 0, 0, $_date1[1], $_date1[2], $_date1[0]);
    $tm2 = mktime(0, 0, 0, $_date2[1], $_date2[2], $_date2[0]);

    return ($tm1 - $tm2) / 86400; // 일수구하기
}


function check_login()
{
	global $PHP_SELF;
	global $_SESSION;

	$querystr = base64_encode(getenv("QUERY_STRING"));

	if (strtolower(getenv("REQUEST_METHOD")) == "post")
	{
		foreach($_POST as $key => $value)
        {
			$param_datas[] = "$key=".@urlencode($value);
        }

        if (sizeof($param_datas) > 0)
    		$str = implode("&", $param_datas);
	}
	else
	{
		$str = getenv("QUERY_STRING");
	}

	$querystr = base64_encode("$PHP_SELF?$str");

	if (!login_status())
	{
        redirect("/admin/login/login_form.php?red_url=$querystr");
	}
}

// 세션에 아이디가 있는지 확인
function login_status()
{
	global $_SESSION;
	if (isset($_SESSION["HANA070_ADMIN_ID"]) && $_SESSION["HANA070_ADMIN_ID"] != "")
		return true;
	else
		return false;
}

function check_admin()
{
	global $PHP_SELF;
	global $_SESSION;

    if ($_SESSION["HANA070_ADMIN_ID"] != 'root')
    {
        alert("잘못된 접근입니다!");
        redirect("/admin/login/login_form.php");
    }
}

// 파일 업로드
function file_upload($_form_name, $_file_name, $_file_size=0, $_save_dir='', $_enable_type='', $_limit_size=0)
{
	global $save_dir;
	global $_FILES;

	if ($save_dir)
		$SaveDir = $save_dir;

	if ($_save_dir)
		$SaveDir = $_save_dir;

    $file_name = $_FILES[$_form_name]['name'];
    $file_type = $_FILES[$_form_name]['type'];
    $file_size = $_FILES[$_form_name]['size'];
    $file_temp = $_FILES[$_form_name]['tmp_name'];

    $new_file_name = "";


    if ($file_size > 0) // 파일 크기가 0보다 크면
	{

        if (!$SaveDir)
        {
            if (!$_save_dir)
                message("업로드할 경로를 지정하세요!");
            else
                $SaveDir = $_save_dir;
        }

        if ($_enable_type)
        {
            if (is_array($_enable_type))
            {
                if ( !in_array($file_type, $_enable_type) )
                    message("업로드 할 수 없는 파일 형식입니다.");
            }
            else
            {
                if ($file_type != $_enable_type)
                    message("업로드 할 수 없는 파일 형식입니다.");
            }
        }

        if ( ($_limit_size > 0) && ($file_size > $_limit_size) )
            message("지정된 파일 사이즈보다 커서 업로드 할 수 없습니다.\\n${_limit_size}bytes 이하로 업로드하시기 바랍니다.");

        // 파일 이름을 '.'으로 분리하여 맨 끝에 스트링을 얻어와 소문자로 변경
		$extension = strtolower( array_pop( explode(".", $file_name) ) );

        // 파일명 만들기
		$new_file_name = sprintf(
            "%s_%s.%s",
            date("YmdHis"),
            substr( md5( uniqid(rand()) ), 0, 8),
            $extension
            );

		if ( file_exists("$SaveDir/$new_file_name") ) message("파일명이 이미 존재합니다");
		if ( !copy($file_temp, "$SaveDir/$new_file_name") ) message("파일을 복사할 수 없습니다");
		if ( !unlink($file_temp) ) message("임시파일을 삭제할 수 없습니다");
        //@chmod("$SaveDir/$new_file_name", 0644);

	    $_file_name = $new_file_name;
		$_file_size = $file_size;

	}
	else
	{
	    $_file_name = "";
		$_file_size = 0;
	}
}



// 파일 업로드
function file_upload2($_form_name, $_file_name, $_file_size=0, $_save_dir='', $_enable_type='', $_limit_size=0, $gisu, $_name)
{
	global $save_dir;
	global $_FILES;

	if ($save_dir)
		$SaveDir = $save_dir;

	if ($_save_dir)
		$SaveDir = $_save_dir;

    $file_name = $_FILES[$_form_name]['name'];
    $file_type = $_FILES[$_form_name]['type'];
    $file_size = $_FILES[$_form_name]['size'];
    $file_temp = $_FILES[$_form_name]['tmp_name'];

    $new_file_name = "";


    if ($file_size > 0) // 파일 크기가 0보다 크면
	{

        if (!$SaveDir)
        {
            if (!$_save_dir)
                message("업로드할 경로를 지정하세요!");
            else
                $SaveDir = $_save_dir;
        }

        if ($_enable_type)
        {
            if (is_array($_enable_type))
            {
                if ( !in_array($file_type, $_enable_type) )
                    message("업로드 할 수 없는 파일 형식입니다.");
            }
            else
            {
                if ($file_type != $_enable_type)
                    message("업로드 할 수 없는 파일 형식입니다.");
            }
        }

        if ( ($_limit_size > 0) && ($file_size > $_limit_size) )
            message("지정된 파일 사이즈보다 커서 업로드 할 수 없습니다.\\n${_limit_size}bytes 이하로 업로드하시기 바랍니다.");

        // 파일 이름을 '.'으로 분리하여 맨 끝에 스트링을 얻어와 소문자로 변경
		$extension = strtolower( array_pop( explode(".", $file_name) ) );

        // 파일명 만들기
		$new_file_name = sprintf(
            "%s_%s.%s",
            date("YmdHis"),
            substr( md5( uniqid(rand()) ), 0, 8),
            $extension
            );

		$new_file_name = sprintf(
            "%s.%s",
			md5($gisu.$_name),
            $extension
			);

		//if ( file_exists("$SaveDir/$new_file_name") ) message("파일명이 이미 존재합니다");
		if ( !copy($file_temp, "$SaveDir/$new_file_name") ) message("파일을 복사할 수 없습니다");
		if ( !unlink($file_temp) ) message("임시파일을 삭제할 수 없습니다");
        //@chmod("$SaveDir/$new_file_name", 0644);

	    $_file_name = $new_file_name;
		$_file_size = $file_size;

	}
	else
	{
	    $_file_name = "";
		$_file_size = 0;
	}
}

function str_cut($str, $len, $dot = "...")
{
	if (strlen($str) > $len)
	{
		if (ord($str[$len - 1]) <= 127)
            $pos = $len;
		else
		{
			for($pos = $len - 1; $pos >= 0; $pos--)
            {
				if (ord($str[$pos]) > 127)
                    $h++;
				else
                    break;
            }

			if ($h%2 == 0)
                $pos += $h + 1;
			else
                $pos += $h;
		}

		$str = substr($str, 0, $pos);
		$str .= $dot;
	}

	return $str;
}

// 이미지 목록 얻기
function fetch_image_list($dir, $code='') {
    if ($dir == ".") $dir = "./";
    if (substr($dir, -1) != "/") { $dir = $dir."/"; }
    $open_dir = opendir($dir);
	$filelist = array();
    while ($read_dir = readdir($open_dir))
    {
		//if ($read_dir != "." && $read_dir != ".." && strpos($read_dir, $code) > -1)
        if ($read_dir != "." && $read_dir != "..")
		{
			$filelist[] = $read_dir;
		}
    }
	return $filelist;
}



//이미지를 투명하게 겹친다
function WatermarkImage($CanvasImage, $WatermarkImage /* MUST BE PNG */, $Opacity=10, $Quality=75){

	// create true color canvas image:
	$canvas_src = imagecreatefromjpeg($CanvasImage);
	$canvas_w = ImageSX($canvas_src);
	$canvas_h = ImageSY($canvas_src);
	$canvas_img = imagecreatetruecolor($canvas_w, $canvas_h);
	imagecopy($canvas_img, $canvas_src, 0,0,0,0, $canvas_w, $canvas_h);
	imagedestroy($canvas_src); // no longer needed

	// create true color overlay image:
	$overlay_src = imagecreatefrompng($WatermarkImage);
	$overlay_w = ImageSX($overlay_src);
	$overlay_h = ImageSY($overlay_src);
	$overlay_img = imagecreatetruecolor($overlay_w, $overlay_h);
	imagecopy($overlay_img, $overlay_src, 0,0,0,0, $overlay_w, $overlay_h);
	imagedestroy($overlay_src); // no longer needed

	// setup transparent color (pick one):
	$black = imagecolorallocate($overlay_img, 0x00, 0x00, 0x00);
	$white = imagecolorallocate($overlay_img, 0xFF, 0xFF, 0xFF);
	$magenta = imagecolorallocate($overlay_img, 0xFF, 0x00, 0xFF);
	// and use it here:
	imagecolortransparent($overlay_img, $white);

	// copy and merge the overlay image and the canvas image:
	imagecopymerge($canvas_img, $overlay_img, 0,0,0,0, $overlay_w, $overlay_h, $Opacity);

	// output:
	header("Content-type: image/jpeg");
	imagejpeg($canvas_img, '', $Quality);

	imagedestroy($overlay_img);
	imagedestroy($canvas_img);
}


function send_sms_list($sms_list) {

	$ar_result = array();

	for ($i = 0; $i < sizeof($sms_list); $i++) {

//		echo '['.$sms_list[$i][PHONE].']['.$sms_list[$i][CALLBACK].']['.$sms_list[$i][MESSAGE].']<BR>';

		$gsmsSocket = new Request();
		$tran_id = "handabal";
		$tran_passwd = "gksekqkf";

		$tran_phone = $sms_list[$i][PHONE];
		$tran_callback = $sms_list[$i][CALLBACK];
		$tran_date = "0";
		$tran_msg = $sms_list[$i][MESSAGE];

		$gsmsSocket->cTranid		= "$tran_id";
		$gsmsSocket->cTranpasswd	= "$tran_passwd";
		$gsmsSocket->cTranphone		= "$tran_phone";
		$gsmsSocket->cTrancallback	= "$tran_callback";
		$gsmsSocket->cTrandate		= "$tran_date";
		$gsmsSocket->cTranmsg		= "$tran_msg";
		$Response = $gsmsSocket->Submit();
		$gsmsSocket->Destroy();
		unset($gsmsSocket);
		unset($Response);
		$ar_result[$i] = $Response;

	}

	return $ar_result;
}

function send_sms($phone, $callback, $msg)
{
	$gsmsSocket = new Request();
	$tran_id = "handabal";
	$tran_passwd = "gksekqkf";
	$tran_phone = $phone;
	$tran_callback = $callback;
	$tran_date = "0";
	$tran_msg = $msg;
	$gsmsSocket->cTranid = "$tran_id";
	$gsmsSocket->cTranpasswd = "$tran_passwd";
	$gsmsSocket->cTranphone = "$tran_phone";
	$gsmsSocket->cTrancallback = "$tran_callback";
	$gsmsSocket->cTrandate = "$tran_date";
	$gsmsSocket->cTranmsg = "$tran_msg";
	$result = $gsmsSocket->Submit();
	$gsmsSocket->Destroy();
	unset($gsmsSocket);
	unset($result);

	return $result;
}

function get_sms_error_msg($error_code) {

	$error_msg = "";

	switch ($error_code)
	{
		case '0':	$error_msg = 'SMS 메시지 전송 성공'; break;
		case '-1':	$error_msg = '데이터 형식이 잘못되었거나 서버 전송 실패'; break;
		case '100': $error_msg = 'SMS 서버에 연결 후 데이터 전송 타임아웃 에러'; break;
		case '200': $error_msg = '가비아 SMS 헤더 에러'; break;
		case '201': $error_msg = '클라이언트 모듈에서 서버로 데이터 전송시 SMS ID 부터 메시지 길이까지의 전체 길이 정보를 보냅니다. 이때 서버에서는 클라이언트에서 보낸 데이터의 길이를 다시 체크해서 데이터 길이가 다를 경우 에러를 리턴합니다.'; break;
		case '202': $error_msg = 'SMS 메시지를 보낼 때는 항상 전송 상태 값이 1이어야 합니다. 1값이 아닐 경우 에러를 리턴합니다.'; break;
		case '203': $error_msg = '메시지 전송시간은 0이거나 현재 시간보다 커야 합니다. 작을 경우 에러를 리턴합니다.'; break;
		case '204': $error_msg = '전송시 메시지 길이가 80자를 넘었습니다. 80자 이상일 경우 에러'; break;
		case '300': $error_msg = 'SMS ID, Password 에러(인증 에러)'; break;
		case '400': $error_msg = 'SMS를 발송할 수 있는 건수가 0일 경우 에러를 리턴합니다.'; break;
		case '500': $error_msg = 'SMS 메시지를 받아 전송하기 위해 DB 인서트시 오류 발생 할 경우 이 에러를 리턴합니다.'; break;
		case '501': $error_msg = 'SMS 전송 요청을 한 후 발송할 수 있는 건수를 마이너스 시킬 때 오류 발생시 에러를 리턴합니다.'; break;
		case '600': $error_msg = '메시지를 전송한 클라이언트의 IP가 데이터 정보에 없을 경우 에러를 리턴합니다.'; break;
		case 'SMS': $error_msg = '메시지를 보내는 서버가 바뀔 경우 꼭 관리 페이지에서 클라이언트 IP를 추가해야 합니다.'; break;
		case '701': $error_msg = '클라이언트 모듈에서 체크하는 에러로 SMS ID 길이가 20byte보다 클 경우 에러'; break;
		case '702': $error_msg = '클라이언트 모듈에서 체크하는 에러로 SMS 패스워드 길이가 20byte보다 클 경우 에러'; break;
		case '703': $error_msg = '클라이언트 모듈에서 체크하는 에러로 수신자 전화 번호 길이가 15byte보다 클 경우 에러'; break;
		case '704': $error_msg = '클라이언트 모듈에서 체크하는 에러로 송신자 전화 번호 길이가 15byte보다 클 경우 에러'; break;
		case '705': $error_msg = '클라이언트 모듈에서 체크하는 에러로 예약 전송을 할 경우 전송 시간 타입 에러(예: 2002-12-25 12:10:11)'; break;
		case '706': $error_msg = '클라이언트 모듈에서 체크하는 에러로 전송 메시지 길이가 80byte 초과할 경우 에러'; break;
		case '707': $error_msg = '클라이언트 모듈에서 체크하는 에러로 전송 데이터 전체 길이 초과 시 에러'; break;
		default :
			$error_msg = "unknown";
	}

	return $error_msg;
}

// 데이터 정렬
function sort_swap($a, $b) { $temp = $a; $a = $b; $b = $temp; }
function bubble_sort($ar, $ar2, $order=0) // 0:오름차순, 1:내림차순
{
	$compcount = 0; // 비교횟수

	for ($i = 0; $i < count($ar); $i++)
	{
		$b_complete = true;
		for ($j = 0; $j < count($ar)-1-$i; $j++)
		{
			//echo "\ni:".$i.",j=".$j;

			$compcount++;
			if ($order) // 내림차순
			{
				if ($ar[$j] < $ar[$j+1])
				{
					$b_complete = false;
					sort_swap($ar[$j], $ar[$j+1]);
					sort_swap($ar2[$j], $ar2[$j+1]);
				}
			}
			else // 오름차순
			{
				if ($ar[$j] > $ar[$j+1])
				{
					$b_complete = false;
					sort_swap($ar[$j], $ar[$j+1]);
					sort_swap($ar2[$j], $ar2[$j+1]);
				}
			}
		}

		if ($b_complete) break;
	}
}

function get_page($total,$view,$link,$page) {
  /***
  $total = 총 게시물 갯수
  $view = 한 페이지에 보여질 게시물 갯수
  $link = 설정된 페이지 링크수, 보통 10개
  $page = 현재 페이지
  ***/
  $p[total] = ceil($total / $view);
  $p[srt] = floor(($page -1) / $link) * $link +1;
  $p[end] = ($p[srt] + $link -1 > $p[total]) ? $p[total] : $p[srt] + $link -1;
  $p[prev] = ($page < $link) ? 0 : $p[srt] -1;
  $p[next] = ($p[end] +1 > $p[total]) ? 0 : $p[end] +1;
  ### 리턴시 prev,next 가 없을 때는 0 을 반환
  return $p;
}
 
 function get_ip() {
	//Just get the headers if we can or else use the SERVER global
	if ( function_exists( 'apache_request_headers' ) ) {
		$headers = apache_request_headers();
	} else {
		$headers = $_SERVER;
	}
	//Get the forwarded IP if it exists
	if ( array_key_exists( 'X-Forwarded-For', $headers ) && filter_var( $headers['X-Forwarded-For'], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 ) ) {
		$the_ip = $headers['X-Forwarded-For'];
	} elseif ( array_key_exists( 'HTTP_X_FORWARDED_FOR', $headers ) && filter_var( $headers['HTTP_X_FORWARDED_FOR'], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 )
	) {
		$the_ip = $headers['HTTP_X_FORWARDED_FOR'];
	} else {
		
		$the_ip = filter_var( $_SERVER['REMOTE_ADDR'], FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 );
	}
	return $the_ip;
}

function phpAlert($input_value) {
	echo "<script>alert('".$input_value."')</script>";  
}


?>